﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{
    public class MilitaryOccupationHistoryManager : AHOBPRBaseBO
    {
        string connectionInfo = string.Empty;

        public MilitaryOccupationHistoryManager(){}
        public MilitaryOccupationHistoryManager(string dbConnInfo)
        {
            connectionInfo = dbConnInfo;
        }
        
        public SortedDictionary<DateTime, List<ServiceSpecificOccupation>> GetRegistrantHistory(string edipi)
        {
            if (string.IsNullOrEmpty(edipi)) throw new ArgumentNullException(nameof(edipi));

            var list = new SortedDictionary<DateTime, List<ServiceSpecificOccupation>>();
            var history = GetMilitaryOccupationHistory(edipi);
            //Console.WriteLine($"HistoryCount for {edipi}: {history.Count()}");
            foreach (var i in history)
            {
                var occupation = GetStdServiceOccupation(i.militaryOccupationData.serviceSpecificOccupationType);
                if (occupation != null)
                {
                   // Console.WriteLine($"Date: {i.militaryOccupationData.serviceOccupationDate} -- ID: {occupation.STD_SERVICE_OCCUPATION_ID}");
                    try
                    {
                        ServiceSpecificOccupation rsso = CreateServiceSpecificOccupation(i, occupation.STD_SERVICE_OCCUPATION_ID);
                        //Console.WriteLine($"in MIlOccMgr: GUID {rsso.LINQEntityGUID}");
                        if (!list.Keys.Contains(rsso.StartDate))
                        {
                           // Console.WriteLine($"NEW KEY: {rsso.StartDate.ToShortDateString()} Adding to list: {rsso.Type}");
                            //No STD_SERVICE_OCCUPATION with this StartDate. Add it.
                            list.Add(rsso.StartDate, new List<ServiceSpecificOccupation> { rsso });
                        }
                        else
                        {
                           // Console.WriteLine("Same key, checking for different service occ code");
                            //If there IS an STD_SERVICE_OCCUPATION with the StartDate, check if we should add an item that has a different ID to the list
                            if (list[rsso.StartDate].All(e => e.OccupationId != rsso.OccupationId))
                            {
                                list[rsso.StartDate].Add(rsso);
                            }
                        }
                    }
                    catch (ArgumentOutOfRangeException ex)
                    {
                        AHOBPRLogger.LogErrorMessage($"ArgumentOutOfRangeException: {ex.Message}", MethodBase.GetCurrentMethod().Name, ex.StackTrace);
                    }
                } }
            return list;
        }

        private static ServiceSpecificOccupation CreateServiceSpecificOccupation(MilitaryOccupation i, int occupationId)
        {
            return new ServiceSpecificOccupation
            {
                OccupationId = occupationId,
                StartDate = i.militaryOccupationData.serviceOccupationDate,
                Type = i.militaryOccupationData.occupationType[0]

            };
        }

        private static List<MilitaryOccupation> GetMilitaryOccupationHistory(string edipi)
        {
            var importer = new MilitaryOccupationImporter();
            return importer.GetMilitaryOccupationData(edipi);
        }
        private  STD_SERVICE_OCCUPATION GetStdServiceOccupation(string occupationCode)
        {
            //Console.WriteLine($"Checking for Code: '{occupationCode}'");
            STD_SERVICE_OCCUPATION occupation = null;
            using (_dbAhobpr = GetLocalContext(connectionInfo))
            {

                occupation = _dbAhobpr.STD_SERVICE_OCCUPATIONs
                                  .FirstOrDefault(
                                        o => o.SERVICE_OCCUPATION_CODE.ToLower() == occupationCode.Trim().ToLower()
                                  );
            }
            return occupation;
        }
    }
}
